/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

#include "SS3c.h"

void SSImprove_solution(SS *pb,int sol[],int *value)
{
	int i,j,inc,old_value,current_pos,new_pos;
	int *order,*sol_inv; /* sol[i]=j <--> sol_inv[j]=i */

	sol_inv=SSInt_array(pb->nvar);
	for(i=1;i<=pb->nvar;i++)
		sol_inv[sol[i]]=i;

	/* Order sectors according to row_sum */
	order = SSOrder_i(pb->row_sum,pb->nvar,1);

   	do{  
    	old_value = *value;
		for(i=1;i<=pb->nvar;i++)
		{
			j=order[i];
			current_pos=sol_inv[j];
			inc = SSFirst_Insert(pb,sol,current_pos,&new_pos);
			if(inc > 0) {
				SSPerform_Move(sol,sol_inv,current_pos,new_pos);
				*value += inc; 
			}

		}
	} while(*value > old_value);

	free(order+1);free(sol_inv+1);
} 

int SSFirst_Insert(SS *pb,int sol[],int i,int *position)
{
/*  Search for the best position to insert i */

	int k,best_inc,inc;
	
	/* Initialize best_inc */
	if(i>2) {
		best_inc  = pb->data_dif[sol[i]][sol[i-1]]; 
		*position = i-1;         
	}
	else {
	 	best_inc  = pb->data_dif[sol[i+1]][sol[i]]; 
		*position = i+1;   
	}

	if(best_inc>0) return best_inc;

	/* Insert i in a previous position */
	inc=0;
	for(k=i-1;k>=1;k--)
	{
		inc += pb->data_dif[sol[i]][sol[k]];                  
		if(inc > best_inc)
		{
			best_inc = inc;
	        *position = k;
			if(best_inc>0) return best_inc;

	    }
	}
	
	/* Insert i in a posterior position */
	inc=0; 	                  
	for(k=i+1;k<=pb->nvar;k++)
	{
		inc += pb->data_dif[sol[k]][sol[i]];   	
	    if(inc > best_inc)
	    {
	    	best_inc  = inc;
	        *position = k;
			if(best_inc>0) return best_inc;
	    }
	}  
	
	return best_inc;
} 

void SSPerform_Move(int sol[],int invsol[],int i,int position)
{
/* Insert element i in position */

	int k,a;
		
	if(position>i) 
	{   
	    a=sol[i];       
		for(k=i; k<position ; k++) 
		{
			sol[k]=sol[k+1];
			invsol[sol[k]]=k;
		}
		sol[position]=a;
		invsol[a]=position;
	}		
	else
	{	
		a=sol[i];  
	    for(k=i;k>position;k--) 
		{
	    	sol[k]=sol[k-1];            
			invsol[sol[k]]=k;
		}
	    sol[position]=a;
		invsol[a]=position;
	}
}
